$(function () {
    $('#container').highcharts({
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            type: 'pie'
        },
        title: {
            text: 'R\351partition des efforts'
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: true,
                    format: '<b>{point.name}</b>: {point.percentage:.1f} %',
                    style: {
                        color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
                    }
                }
            }
        },
        series: [{
            name: 'Brands',
            colorByPoint: true,
            data: [{
                name: 'D\351veloppement des affaires',
                y: 52.8
            }, {
                name: 'Administration',
                y: 21.7,
                sliced: true,
                selected: true
            }, {
                name: 'R&D',
                y: 14.4
            }, {
                name: 'Communication Marketing',
                y: 12
            }, {
                name: 'Op\351rations',
                y: 9
            }, {
                name: 'Produit',
                y: 5
            }]
        }]
    });
});